function [] = curatefields(dir_tmp,out_tmp)
%Currate files that are generated as a free frame mosaic.  This will put
%each frame into its own folder
%Synatax:   [] = curatefields();
%Input:     dir_tmp = the directory of interest
%           out_tmp = where the currated directory goes
%           note: if you enter dir_tmp you will need out_tmp
%Output:    no output at this moment

%where are the files?
if nargin==0
    dir_tmp = uigetdir2('','Directory of image folders with fields');    %get the directory
    out_tmp = uigetdir3('','Where do you want the new currated directory');
end

%lets process the root
dir_root = dir(dir_tmp);  %grab the root
idx = [dir_root.isdir];   %grab all of the isdir numbers - the first two
idx(1:2) = 0;
curr_names = {dir_root.name};   %grab the all of the names in the root
dir_list = curr_names(idx);    %the directory names in root
%make the currated directory
mkdir(out_tmp,'field_data');
out_tmp = repmat([out_tmp,filesep,'field_data',filesep],size(dir_list'));    %replicated the out_put name for appending
out_list = horzcat(cellstr(out_tmp),dir_list');      %now each cell contains the full output directory path
dir_tmp = repmat([dir_tmp filesep],size(dir_list'));    %replicated the directory name for appending
dir_list = cellstr([dir_tmp char(dir_list')]);      %now each cell contains the full directory path

if ~isempty(dir_list)   %if the root only have files, then no need to go further
    while 1     %we are going to dig the for all of the files
        dir_tmp = [];   %clear!
        out_tmp = [];
        dir_end = 0;    %reset
        %level in
        for i = 1:size(dir_list,1)  %for each dir_step down one
            %mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
            curr_dir = dir_list{i};     %current directory
            dir_info = dir(dir_list{i}); %grab the current dir
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            curr_names = {dir_info.name};   %grab the all of the names
            %if there are files move over if they meet criteria
            %grab the filenames
            curr_file = curr_names(~idx);   %filenames
            idx(1:2) = 0;   %toss the first two
            dir_nxt = curr_names(idx);    %the directories
            if ~isempty(curr_file)  %there are files
                %process tif files
                [filenames] = parsefields(curr_file,'_F');
                %now copy these files over
                for k = 1:size(filenames,1)
                    %Lets just modify the output directory
                    mod_idx = strfind(curr_out,filesep);
                    sessionnum = curr_out(mod_idx(end)+1);
                    curr_out_tmp = [curr_out(1:mod_idx(end-1)),'field',num2str(k),filesep,'session',sessionnum,curr_out(mod_idx(end):end)];
                    mkdir(curr_out_tmp);
                    for l = 1:size(filenames,2)
                        if ~isempty(filenames{k,l})
                            copyfile([curr_dir,filesep,filenames{k,l}],[curr_out_tmp]);
                        end
                    end
                end
            end
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
            else    %not the bottom
                curr_out = repmat([curr_out filesep],size(dir_nxt'));    %replicated the out_put name for appending
                out_tmp = vertcat(out_tmp,horzcat(cellstr(curr_out),dir_nxt'));      %now each cell contains the full output directory path
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
            end
        end
        if dir_end==size(dir_list,1)    %all directories are at an end
            break
        else    %move next level down
            dir_list = dir_tmp;
            out_list = out_tmp;
        end
    end
end
%--------------------------------------------------------------------------
%Parse the files to extract the files to copy over
function [filenames] = parsefields(curr_file,field_designator)
fieldnumber = {};  %initiate
iter = [];
for j = 1:size(curr_file,2);  %first lets find how many fields there are
    fieldnumidx = strfind(curr_file{j},field_designator);  %See if the file has a field designator
    if ~isempty(fieldnumidx)  %if it is has a field designator
        curr_field = curr_file{j}(fieldnumidx:end);
        newfield = strcmpi(fieldnumber,curr_field);  %check if we have seen this field already
        if max(newfield)  %old field
            fieldidx = find(newfield==1);  %which field is it
            iter(fieldidx) = iter(fieldidx)+1;  %iterate its index by one
        else  %have not seen it before
            fieldnumber = horzcat(fieldnumber,curr_field);
            fieldidx = size(fieldnumber,2);
            iter = horzcat(iter,1);  %create new index of iteration
        end
        filenames{fieldidx,iter(fieldidx)} = curr_file{j};
    end
end